#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "gmp.h"
#include "api.h"
#include "kaz_api.h"

int
crypto_kem_keypair(unsigned char *pk, unsigned char *sk)
{
    int status=KAZ_KEM_KEYGEN(pk, sk);

    if(status==0) return 0;
    else return -4;
}

int
crypto_encap(unsigned char *encapsulate, unsigned long long *encaplen,
             const unsigned char *m, unsigned long long mlen,
             const unsigned char *pk)
{
    int status=KAZ_KEM_ENCAPSULATION(encapsulate, encaplen, m, mlen, pk);

    if(status==0) return 0;
    else return status;
}

int
crypto_decap(unsigned char *decapsulate, unsigned long long *decaplen,
             const unsigned char *encapsulate, unsigned long long encaplen,
             const unsigned char *sk)
{

    int status=KAZ_KEM_DECAPSULATION(decapsulate, decaplen, encapsulate, encaplen, sk);

    if(status==0) return 0;
    else return status;
}
